<?php 
	$list = DAOFactory::getTblLeaveCreditsDAO()->showLeaveCreditsListUser();
?>
<div class="box-standard">
	<div class="row">
		<div class="col-lg-6 col-sm-6">
			<div class="page-header-standard"><i class="pe-7s-angle-right-circle pe-lg"></i> Leave Credits</div>
		</div>
		<div class="col-lg-6 col-sm-6 text-right">
			<button class="btn btn-success sample"><i class="pe-7s-plus pe-lg"></i> Add Leave Credits</button>
		</div>
	</div>
</div>
<form method="post" id="formLeaveCredits">
	
<div id="sampleModal" class="modal fade" role="dialog">
	<div class="modal-dialog modal-lg">

	<div class="modal-content">
		<div class="modal-header">
			<h4 class="modal-title">Add Leave Credits</h4>
		</div>
		<div class="modal-body">
			<div class="form-group row">
				<label class="col-md-3">Regular Employee:</label>
				<div class="col-md-9">
					<select name="user" required class="form-control selectpicker" data-live-search="true">
					</select>
				</div>
			</div>
			<div class="form-group row">
				<label class="col-md-3">Leave Type</label>
				<div class="col-md-9">
					<select class="form-control" required name="leave_type" id="leaveType"></select>
				</div>
			</div>
			<div class="form-group row mt-10" style="padding: 30px;">
				<div class="col-md-12">
				<table class="table table-standard table-striped" id="leaveTypeTable">
					<thead>
						<th>Leave Code</th>
						<th>Credits</th>
					</thead>
					<tbody>
					</tbody>
				</table>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button type="submit" class="btn btn-success">Save</button>
			<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
		</div>
	</div>

	</div>
</div>
</form>
<form method="post" id="updateLeaveCreditsForm">
	
<div id="updateLeaveCreditsModal" class="modal fade" role="dialog">
	<div class="modal-dialog modal-lg">

	<div class="modal-content">
		<div class="modal-header">
			<h4 class="modal-title">Update Leave Credits</h4>
			<input name="leaveCreditId" id="leaveCreditId" type="hidden">
			<input name="leaveUserId" id="leaveUserId" type="hidden">
		</div>
		<div class="modal-body returnLeaveCredits mb-20">
			
		</div>
		<div class="modal-footer">
			<button type="submit" class="btn btn-success">Save</button>
			<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
		</div>
	</div>

	</div>
</div>
</form>
<div class="box-standard">
	<div class="row">
		<div class="col-lg-12 col-sm-12">
			<div class="table-responsive">
				<table class="table table-standard table-bordered" id="leave_credits_table">
					<thead>
						<th><i class="pe pe-7s-config pe-lg"></i></th>
						<th>Name</th>
						<th>Leave Type</th>
						<th>Total Credits</th>
						<th>Leave Code</th>
						<th>Credit</th>
					</thead>
					<tbody>
						<?php foreach ($list as $key => $value): $data = 1; ?>
							<?php $list2 = DAOFactory::getTblLeaveCreditsDAO()->showLeaveCreditsListUser($value['leave_credit_id']);?>
							<?php foreach ($list2 as $key => $value2): ?>
								<tr>	
									<?php if($data == 1):?>
									<td rowspan="<?=count($list2)?>">
										<a class="updateLeaveCredits btn-edit-standard" userId="<?=$value2['id']?>">
										<i class="fa fa-pencil-square-o"></i></a>
									</td>
									<td rowspan="<?=count($list2)?>"><?= $value2['name'] ?></td>
									<td rowspan="<?=count($list2)?>"><?= $value2['leave_type'] ?></td>
									<td rowspan="<?=count($list2)?>"><?= $value2['total_credits'] ?></td>
									<?php $data++;?>
									<?php endif; ?>
									<td><?= $value2['code'] ?></td>
									<td><?= $value2['credits'] ?></td>
								</tr>
							<?php endforeach;?>
						<?php endforeach;?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<script src="<?=URL?>public/js/employee/leave_credits.js"></script>