<?php
/**
 * Class that operate on table 'tbl_scope_of_work'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-05-27 08:17
 */
class TblScopeOfWorkMySqlDAO implements TblScopeOfWorkDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblScopeOfWorkMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_scope_of_work WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_scope_of_work';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_scope_of_work ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblScopeOfWork primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_scope_of_work WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblScopeOfWorkMySql tblScopeOfWork
 	 */
	public function insert($tblScopeOfWork){
		$sql = 'INSERT INTO tbl_scope_of_work (service_line_id, scope, description, date_created, date_modified) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblScopeOfWork->serviceLineId);
		$sqlQuery->set($tblScopeOfWork->scope);
		$sqlQuery->set($tblScopeOfWork->description);
		$sqlQuery->set($tblScopeOfWork->dateCreated);
		$sqlQuery->set($tblScopeOfWork->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblScopeOfWork->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblScopeOfWorkMySql tblScopeOfWork
 	 */
	public function update($tblScopeOfWork){
		$sql = 'UPDATE tbl_scope_of_work SET service_line_id = ?, scope = ?, description = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblScopeOfWork->serviceLineId);
		$sqlQuery->set($tblScopeOfWork->scope);
		$sqlQuery->set($tblScopeOfWork->description);
		$sqlQuery->set($tblScopeOfWork->dateCreated);
		$sqlQuery->set($tblScopeOfWork->dateModified);

		$sqlQuery->setNumber($tblScopeOfWork->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_scope_of_work';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByServiceLineId($value){
		$sql = 'SELECT * FROM tbl_scope_of_work WHERE service_line_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByScope($value){
		$sql = 'SELECT * FROM tbl_scope_of_work WHERE scope = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDescription($value){
		$sql = 'SELECT * FROM tbl_scope_of_work WHERE description = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_scope_of_work WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_scope_of_work WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByServiceLineId($value){
		$sql = 'DELETE FROM tbl_scope_of_work WHERE service_line_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByScope($value){
		$sql = 'DELETE FROM tbl_scope_of_work WHERE scope = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDescription($value){
		$sql = 'DELETE FROM tbl_scope_of_work WHERE description = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_scope_of_work WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_scope_of_work WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblScopeOfWorkMySql 
	 */
	protected function readRow($row){
		$tblScopeOfWork = new TblScopeOfWork();
		
		$tblScopeOfWork->id = $row['id'];
		$tblScopeOfWork->serviceLineId = $row['service_line_id'];
		$tblScopeOfWork->scope = $row['scope'];
		$tblScopeOfWork->description = $row['description'];
		$tblScopeOfWork->dateCreated = $row['date_created'];
		$tblScopeOfWork->dateModified = $row['date_modified'];

		return $tblScopeOfWork;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblScopeOfWorkMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>