<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
interface TblLeaveTypeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblLeaveType 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblLeaveType primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblLeaveType tblLeaveType
 	 */
	public function insert($tblLeaveType);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblLeaveType tblLeaveType
 	 */
	public function update($tblLeaveType);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByLeaveTypeNo($value);

	public function queryByLeaveType($value);

	public function queryByDescription($value);

	public function queryByStatus($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByLeaveTypeNo($value);

	public function deleteByLeaveType($value);

	public function deleteByDescription($value);

	public function deleteByStatus($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>