<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblCostCenterDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblCostCenter 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblCostCenter primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblCostCenter tblCostCenter
 	 */
	public function insert($tblCostCenter);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblCostCenter tblCostCenter
 	 */
	public function update($tblCostCenter);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByCompany($value);

	public function queryByNumber($value);

	public function queryByDescription($value);

	public function queryByDimension($value);


	public function deleteByCompany($value);

	public function deleteByNumber($value);

	public function deleteByDescription($value);

	public function deleteByDimension($value);


}
?>