<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface ClClientsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return ClClients 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param clClient primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param ClClients clClient
 	 */
	public function insert($clClient);
	
	/**
 	 * Update record in table
 	 *
 	 * @param ClClients clClient
 	 */
	public function update($clClient);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByEmail($value);

	public function queryByName($value);

	public function queryByClientName($value);

	public function queryByStatus($value);

	public function queryByRName($value);

	public function queryByREmail($value);

	public function queryByGrpId($value);


	public function deleteByEmail($value);

	public function deleteByName($value);

	public function deleteByClientName($value);

	public function deleteByStatus($value);

	public function deleteByRName($value);

	public function deleteByREmail($value);

	public function deleteByGrpId($value);


}
?>