<div class="box-standard">
	<div class="row">
		<div class="col-lg-6 col-sm-6">
			<div class="page-header-standard"><i class="pe-7s-angle-right-circle pe-lg"></i> Company per Department Setup</div>
		</div>
		<div class="col-lg-6 col-sm-6 text-right">
			<button class="btn btn-success sample"><i class="pe-7s-plus pe-lg"></i> Add Company per Department</button>
		</div>
	</div>
</div>
<form method="post" id="formCompPerDept">
	
<div id="sampleModal" class="modal fade" role="dialog">
	<div class="modal-dialog">

	<!-- Modal content-->
	<div class="modal-content">
		<div class="modal-header">
			<h4 class="modal-title">Add Company per Department</h4>
		</div>
		<div class="modal-body">
			<div class="row">
				<div class="form-group">
					<label class="col-lg-2">Company:</label>
					<div class="col-lg-10">		
						<select class="form-control" name="company" id="company" data-live-search="true">
						</select>
					</div>
				</div>
				<div class="clearfix"></div>
				<div class=" mt-10">
					<div class="form-group">
						<label class="col-lg-2">Department: </label>
						<div class="col-lg-8">	
						</div>
						<div class="col-lg-2">
						</div>
					</div>
				</div>
				<div class="clearfix"></div>
				<div class="dept mt-10">
					<div class="form-group">
						<div class="col-lg-10">
							<select required class="form-control  department" name="department[]"></select>
						</div>
						<div class="col-lg-2">
							<button type="button" class="btn btn-success btnAdd"><span class="glyphicon glyphicon-plus"></span></button>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button type="submit" class="btn btn-success">Save</button>
			<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
		</div>
	</div>

	</div>
</div>
</form>
<div class="box-standard">
	<div class="row">
		<div class="col-lg-12 col-sm-12">
			<div class="table-responsive">
				<table class="table table-standard" id="companyPerDept_table">

				</table>	
			</div>
		</div>
	</div>
</div>
<script>

	var table = $('#companyPerDept_table').DataTable({
	"columns": [{
        "title": "Company",
        "data": "company"
    }, {
        "title": "Department",
        "data": "department"

    }], 
    "ordering": false
    
});
	$(function(){
		populateDT('setup/getCompanyPerDept', table);
		getDepartment();
		getCompany();
		$('.sample').click(function(){
			$('#sampleModal').modal({
			  	backdrop: 'static', 
			    keyboard: false,
			    toggle: true
			 });
		});

		var x=1;
		$('.btnAdd').click(function(){
			x++;
			$('.dept').append
			(
				'<div class="form-group">'+
					'<div class="col-lg-10 mt-10">'+
						'<select  required class="form-control  department" name="department[]">'+
						'</select>'+
					'</div>'+
					'<div class="col-lg-2 mt-10">'+
						'<button type="button" class="btnMinus btn btn-danger"><span class="glyphicon glyphicon-minus"></span></button>'+
					'</div>'+
				'</div>'
			);
			
			getDepartment();
			getCompany();
			$(".btnMinus").on("click", function() {
				$(this).closest('div.form-group').remove();
				// alert();
			})
		});

		$('#formCompPerDept').submit(function(){

			var data = $(this).serialize();

			saveAlert('You want to add this data?', function(){

				$.post(URL + 'setup/saveCompanyPerDept', data)
				.done(function(returnData){
					populateDT('setup/getCompanyPerDept', table);
					$('.modal').modal('hide');
					$('#sampleModal').find("input,textarea,select").val('').end()

				});

				return false;

			})
			return false;

		});


	});

	function getCompany(){

		$.post(URL + 'setup/getCompany')
		.done(function(returnData){
			
			var data = $.parseJSON(returnData);

			var append = '';

			$.each(data, function(key, a){

				append += '<option value='+a.id+'>'+a.company+'</option>';

			});
			$('#company').html(append);
			$('#company').selectpicker('refresh');
		});
	}

	function getDepartment(){

		$.post(URL + 'setup/getDepartment')
		.done(function(returnData){

			var data = $.parseJSON(returnData);
			var append = '';

			$.each(data, function(key, a){

				append += '<option value='+a.id+'>'+a.department+'</option>';

			});

			$('select.department').html(append);
			$('select.department').selectpicker('refresh');
		});
	}




</script>