<?php
/**
 * Class that operate on table 'tbl_allowance'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-02-19 03:35
 */
class TblAllowanceMySqlDAO implements TblAllowanceDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblAllowanceMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_allowance WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_allowance';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_allowance ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblAllowance primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_allowance WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblAllowanceMySql tblAllowance
 	 */
	public function insert($tblAllowance){
		$sql = 'INSERT INTO tbl_allowance (province_id, meal, transpo, meal_excess, transpo__excess, minimum_hrs, excess_hrs, status, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblAllowance->provinceId);
		$sqlQuery->set($tblAllowance->meal);
		$sqlQuery->set($tblAllowance->transpo);
		$sqlQuery->set($tblAllowance->mealExcess);
		$sqlQuery->set($tblAllowance->transpo_excess);
		$sqlQuery->set($tblAllowance->minimumHrs);
		$sqlQuery->set($tblAllowance->excessHrs);
		$sqlQuery->set($tblAllowance->status);
		$sqlQuery->setNumber($tblAllowance->createdBy);
		$sqlQuery->setNumber($tblAllowance->modifiedBy);
		$sqlQuery->set($tblAllowance->dateCreated);
		$sqlQuery->set($tblAllowance->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblAllowance->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblAllowanceMySql tblAllowance
 	 */
	public function update($tblAllowance){
		$sql = 'UPDATE tbl_allowance SET province_id = ?, meal = ?, transpo = ?, meal_excess = ?, transpo__excess = ?, minimum_hrs = ?, excess_hrs = ?, status = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblAllowance->provinceId);
		$sqlQuery->set($tblAllowance->meal);
		$sqlQuery->set($tblAllowance->transpo);
		$sqlQuery->set($tblAllowance->mealExcess);
		$sqlQuery->set($tblAllowance->transpo_excess);
		$sqlQuery->set($tblAllowance->minimumHrs);
		$sqlQuery->set($tblAllowance->excessHrs);
		$sqlQuery->set($tblAllowance->status);
		$sqlQuery->setNumber($tblAllowance->createdBy);
		$sqlQuery->setNumber($tblAllowance->modifiedBy);
		$sqlQuery->set($tblAllowance->dateCreated);
		$sqlQuery->set($tblAllowance->dateModified);

		$sqlQuery->setNumber($tblAllowance->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_allowance';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByProvinceId($value){
		$sql = 'SELECT * FROM tbl_allowance WHERE province_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMeal($value){
		$sql = 'SELECT * FROM tbl_allowance WHERE meal = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTranspo($value){
		$sql = 'SELECT * FROM tbl_allowance WHERE transpo = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMealExcess($value){
		$sql = 'SELECT * FROM tbl_allowance WHERE meal_excess = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTranspo_excess($value){
		$sql = 'SELECT * FROM tbl_allowance WHERE transpo__excess = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMinimumHrs($value){
		$sql = 'SELECT * FROM tbl_allowance WHERE minimum_hrs = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByExcessHrs($value){
		$sql = 'SELECT * FROM tbl_allowance WHERE excess_hrs = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_allowance WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_allowance WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_allowance WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_allowance WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_allowance WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByProvinceId($value){
		$sql = 'DELETE FROM tbl_allowance WHERE province_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMeal($value){
		$sql = 'DELETE FROM tbl_allowance WHERE meal = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTranspo($value){
		$sql = 'DELETE FROM tbl_allowance WHERE transpo = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMealExcess($value){
		$sql = 'DELETE FROM tbl_allowance WHERE meal_excess = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTranspo_excess($value){
		$sql = 'DELETE FROM tbl_allowance WHERE transpo__excess = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMinimumHrs($value){
		$sql = 'DELETE FROM tbl_allowance WHERE minimum_hrs = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByExcessHrs($value){
		$sql = 'DELETE FROM tbl_allowance WHERE excess_hrs = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_allowance WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_allowance WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_allowance WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_allowance WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_allowance WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblAllowanceMySql 
	 */
	protected function readRow($row){
		$tblAllowance = new TblAllowance();
		
		$tblAllowance->id = $row['id'];
		$tblAllowance->provinceId = $row['province_id'];
		$tblAllowance->meal = $row['meal'];
		$tblAllowance->transpo = $row['transpo'];
		$tblAllowance->mealExcess = $row['meal_excess'];
		$tblAllowance->transpo_excess = $row['transpo__excess'];
		$tblAllowance->minimumHrs = $row['minimum_hrs'];
		$tblAllowance->excessHrs = $row['excess_hrs'];
		$tblAllowance->status = $row['status'];
		$tblAllowance->createdBy = $row['created_by'];
		$tblAllowance->modifiedBy = $row['modified_by'];
		$tblAllowance->dateCreated = $row['date_created'];
		$tblAllowance->dateModified = $row['date_modified'];

		return $tblAllowance;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblAllowanceMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>