<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
interface TblPbsFileDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblPbsFile 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblPbsFile primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblPbsFile tblPbsFile
 	 */
	public function insert($tblPbsFile);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblPbsFile tblPbsFile
 	 */
	public function update($tblPbsFile);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySubsyncId($value);

	public function queryBySubdomain($value);

	public function queryByPbsId($value);

	public function queryByFileName($value);

	public function queryByFileType($value);

	public function queryByFileSize($value);

	public function queryByFileContent($value);

	public function queryByFileExtension($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteBySubsyncId($value);

	public function deleteBySubdomain($value);

	public function deleteByPbsId($value);

	public function deleteByFileName($value);

	public function deleteByFileType($value);

	public function deleteByFileSize($value);

	public function deleteByFileContent($value);

	public function deleteByFileExtension($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>