<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
interface TblDailyForecastPerTimeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblDailyForecastPerTime 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblDailyForecastPerTime primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDailyForecastPerTime tblDailyForecastPerTime
 	 */
	public function insert($tblDailyForecastPerTime);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDailyForecastPerTime tblDailyForecastPerTime
 	 */
	public function update($tblDailyForecastPerTime);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySubsyncId($value);

	public function queryBySubdomain($value);

	public function queryByDailyForecastId($value);

	public function queryByNbtTimeId($value);

	public function queryByTarget($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteBySubsyncId($value);

	public function deleteBySubdomain($value);

	public function deleteByDailyForecastId($value);

	public function deleteByNbtTimeId($value);

	public function deleteByTarget($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>