-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               10.1.26-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win32
-- HeidiSQL Version:             9.4.0.5173
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Dumping structure for table job_acc_v2.job_notification
CREATE TABLE IF NOT EXISTS `job_notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `job_id` int(11) NOT NULL,
  `applicant_id` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `date_notify` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.job_notification: ~0 rows (approximately)
/*!40000 ALTER TABLE `job_notification` DISABLE KEYS */;
/*!40000 ALTER TABLE `job_notification` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_admin
CREATE TABLE IF NOT EXISTS `tbl_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `admin_fname` varchar(100) NOT NULL,
  `admin_mname` varchar(100) NOT NULL,
  `admin_lname` varchar(100) NOT NULL,
  `date_registered` date NOT NULL,
  `type` varchar(100) NOT NULL COMMENT 'main : main admin ; admin : sub admin;',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_admin: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_admin` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_admin` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_admin_delay
CREATE TABLE IF NOT EXISTS `tbl_admin_delay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) NOT NULL,
  `date_deleted` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `admin_id` (`admin_id`),
  CONSTRAINT `tbl_admin_delay_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `tbl_admin` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_admin_delay: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_admin_delay` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_admin_delay` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_admin_done
CREATE TABLE IF NOT EXISTS `tbl_admin_done` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) NOT NULL,
  `work_done` varchar(1000) NOT NULL,
  `work_type` enum('job','employer','applicant') NOT NULL,
  `type_id` int(11) NOT NULL,
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `admin_id` (`admin_id`),
  CONSTRAINT `tbl_admin_done_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `tbl_admin` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_admin_done: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_admin_done` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_admin_done` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_admin_info
CREATE TABLE IF NOT EXISTS `tbl_admin_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) NOT NULL,
  `gender` varchar(10) NOT NULL,
  `address` varchar(500) NOT NULL,
  `employee_position` varchar(100) NOT NULL,
  `phone_no` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `admin_id` (`admin_id`),
  CONSTRAINT `tbl_admin_info_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `tbl_admin` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_admin_info: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_admin_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_admin_info` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_admin_notification
CREATE TABLE IF NOT EXISTS `tbl_admin_notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) NOT NULL,
  `notification` varchar(1000) NOT NULL,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_admin_notification: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_admin_notification` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_admin_notification` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_applicants
CREATE TABLE IF NOT EXISTS `tbl_applicants` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL,
  `password` varchar(100) NOT NULL,
  `firstname` varchar(100) NOT NULL,
  `midname` varchar(100) NOT NULL,
  `lastname` varchar(100) NOT NULL,
  `work_experience_months` varchar(11) NOT NULL,
  `field` enum('Accounting','Audit','Consulting','Finance','System','Tax') NOT NULL,
  `expected_monthly_salary` varchar(100) NOT NULL,
  `job_activity` enum('Actively looking for job','Employed but open for new oppurtunity','Employed') NOT NULL,
  `receive_updates` enum('yes','no') NOT NULL,
  `work_location_country` varchar(100) NOT NULL,
  `overseas` enum('Yes','No') NOT NULL,
  `date_registered` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `disable_status` int(11) NOT NULL COMMENT '0 - not disabled ; 1 - disabled ; 2 - unverified',
  `disable_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `employment_status` enum('Actively looking for a job','Employed but open for new opportunity','Employed','') NOT NULL,
  `receive_newsletter` enum('Yes','No') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_applicants: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_applicants` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_applicants` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_applicants_info
CREATE TABLE IF NOT EXISTS `tbl_applicants_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `applicants_id` int(11) NOT NULL,
  `phone_no` varchar(100) NOT NULL,
  `gender` varchar(10) NOT NULL,
  `birthdate` varchar(20) NOT NULL,
  `house_no` varchar(100) NOT NULL,
  `street` varchar(100) NOT NULL,
  `city_address` varchar(100) NOT NULL,
  `state_address` varchar(100) NOT NULL,
  `country` varchar(100) NOT NULL,
  `civil_status` varchar(1000) NOT NULL,
  `nationality` varchar(100) NOT NULL,
  `preferred_work_location` varchar(100) NOT NULL,
  `continent` varchar(100) NOT NULL,
  `zip_postal_code` varchar(100) NOT NULL,
  `additional_information` varchar(1000) NOT NULL,
  `resume_title` varchar(100) NOT NULL,
  `present_job_title` varchar(100) NOT NULL,
  `cover_letter_type` varchar(1) NOT NULL,
  `cover_letter` varchar(10000) NOT NULL,
  `resume_type` varchar(1) NOT NULL,
  `resume` varchar(10000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `applicants_id` (`applicants_id`),
  CONSTRAINT `tbl_applicants_info_ibfk_1` FOREIGN KEY (`applicants_id`) REFERENCES `tbl_applicants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_applicants_info: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_applicants_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_applicants_info` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_applicants_notification
CREATE TABLE IF NOT EXISTS `tbl_applicants_notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `applicants_id` int(11) NOT NULL,
  `notification` varchar(1000) NOT NULL,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_applicants_notification: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_applicants_notification` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_applicants_notification` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_applicant_files
CREATE TABLE IF NOT EXISTS `tbl_applicant_files` (
  `id` int(25) NOT NULL AUTO_INCREMENT,
  `applicant_id` int(11) NOT NULL,
  `title` varchar(250) NOT NULL DEFAULT '',
  `file_name` varchar(250) NOT NULL DEFAULT '',
  `file_type` varchar(15) NOT NULL DEFAULT '',
  `file_size` varchar(45) NOT NULL DEFAULT '',
  `file_content` longblob NOT NULL,
  `file_extension` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_applicant_files: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_applicant_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_applicant_files` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_applied_jobs
CREATE TABLE IF NOT EXISTS `tbl_applied_jobs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `applicant_id` int(11) NOT NULL,
  `job_id` int(11) NOT NULL,
  `date_applied` date NOT NULL,
  `status` enum('Pending','Invited') NOT NULL,
  `update_date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `applicant_id` (`applicant_id`),
  KEY `job_id` (`job_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_applied_jobs: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_applied_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_applied_jobs` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_contact_inquiry
CREATE TABLE IF NOT EXISTS `tbl_contact_inquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `question` varchar(1000) COLLATE utf8_unicode_ci NOT NULL,
  `type` int(11) NOT NULL COMMENT '0 - applicant ; 1 - employer',
  `name` varchar(1000) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `subject` varchar(1000) COLLATE utf8_unicode_ci NOT NULL,
  `message` varchar(1000) COLLATE utf8_unicode_ci NOT NULL,
  `date_submitted` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table job_acc_v2.tbl_contact_inquiry: 0 rows
/*!40000 ALTER TABLE `tbl_contact_inquiry` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_contact_inquiry` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_currency
CREATE TABLE IF NOT EXISTS `tbl_currency` (
  `id` int(11) NOT NULL,
  `country` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `symbol` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_currency: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_currency` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_currency` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_educational_background
CREATE TABLE IF NOT EXISTS `tbl_educational_background` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL COMMENT '0 - primary ; 1 - secondary ; 2 - tertiary ; 3 - post graduate ; 4 - vocational',
  `applicant_id` int(11) NOT NULL,
  `major` varchar(100) NOT NULL,
  `course` varchar(100) NOT NULL,
  `college` varchar(100) NOT NULL,
  `college_address` varchar(100) NOT NULL,
  `period_to` int(11) NOT NULL,
  `period_from` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_educational_background: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_educational_background` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_educational_background` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_employers
CREATE TABLE IF NOT EXISTS `tbl_employers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_name` varchar(1000) NOT NULL,
  `fname` varchar(100) NOT NULL,
  `mname` varchar(100) NOT NULL,
  `lname` varchar(100) NOT NULL,
  `user_position` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(100) NOT NULL,
  `date_registered` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `disable_status` int(11) NOT NULL COMMENT '0 - not disabled ; 1 - disabled ; 2 - unverified',
  `disable_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` int(11) NOT NULL DEFAULT '0' COMMENT '0 - registered; 1 - added by admin',
  `verified_status` int(11) NOT NULL COMMENT '0 - unverified ; 1 - verified',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_employers: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_employers` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_employers` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_employers_files
CREATE TABLE IF NOT EXISTS `tbl_employers_files` (
  `id` int(25) NOT NULL AUTO_INCREMENT,
  `employers_id` int(11) NOT NULL,
  `title` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `file_name` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `file_type` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `file_size` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `file_content` longblob NOT NULL,
  `file_extension` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `employers_id` (`employers_id`)
) ENGINE=MyISAM AUTO_INCREMENT=258 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table job_acc_v2.tbl_employers_files: 0 rows
/*!40000 ALTER TABLE `tbl_employers_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_employers_files` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_employers_info
CREATE TABLE IF NOT EXISTS `tbl_employers_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employer_id` int(11) NOT NULL,
  `address1` varchar(500) NOT NULL,
  `address2` varchar(500) NOT NULL,
  `city` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `country` varchar(100) NOT NULL,
  `zip_postal_code` varchar(100) NOT NULL,
  `home_phone` varchar(100) NOT NULL,
  `office_phone1` varchar(100) NOT NULL,
  `office_phone2` varchar(100) NOT NULL,
  `fax` varchar(100) NOT NULL,
  `website` varchar(500) NOT NULL,
  `source` varchar(500) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `employer_id` (`employer_id`),
  CONSTRAINT `tbl_employers_info_ibfk_1` FOREIGN KEY (`employer_id`) REFERENCES `tbl_employers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_employers_info: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_employers_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_employers_info` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_employers_notification
CREATE TABLE IF NOT EXISTS `tbl_employers_notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employer_id` int(11) NOT NULL,
  `notification` varchar(1000) NOT NULL,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_employers_notification: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_employers_notification` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_employers_notification` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_jobs
CREATE TABLE IF NOT EXISTS `tbl_jobs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employer_id` int(11) NOT NULL,
  `job_title` varchar(100) NOT NULL,
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` enum('approved','pending-add','disapproved','trashed','closed') NOT NULL DEFAULT 'pending-add',
  `update_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `trashed_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_interval` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `employer_id` (`employer_id`),
  CONSTRAINT `tbl_jobs_ibfk_1` FOREIGN KEY (`employer_id`) REFERENCES `tbl_employers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_jobs: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_jobs` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_jobs_info
CREATE TABLE IF NOT EXISTS `tbl_jobs_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `job_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  `job_code` varchar(100) NOT NULL,
  `job_type` enum('internal','external') NOT NULL,
  `position_quantity` int(11) NOT NULL,
  `headline` varchar(300) NOT NULL,
  `location_city` varchar(100) NOT NULL DEFAULT '',
  `location_state` varchar(100) NOT NULL DEFAULT '',
  `location_country` varchar(100) NOT NULL DEFAULT 'Philippines',
  `category` varchar(100) NOT NULL,
  `description` varchar(3000) NOT NULL,
  `position_type` varchar(100) NOT NULL DEFAULT 'Employee',
  `job_hours` int(11) NOT NULL COMMENT '0 : full time ; 1 : part time',
  `education_required` varchar(100) NOT NULL,
  `experience_required` varchar(100) NOT NULL,
  `min_salary` varchar(100) NOT NULL,
  `max_salary` varchar(100) NOT NULL,
  `pay_period` enum('Per Hour','Per Day','Per Week','Per Half and End of Month','Per Month','Per Year') NOT NULL,
  `currency` varchar(100) NOT NULL,
  `car_availability` varchar(50) NOT NULL DEFAULT 'no',
  `car_allowance` varchar(50) NOT NULL DEFAULT 'no',
  `stock_options` varchar(50) NOT NULL DEFAULT 'no',
  `h1b_sponsorship` varchar(50) NOT NULL DEFAULT 'no',
  `paid_relocation` varchar(50) NOT NULL DEFAULT 'no',
  `additional_information` varchar(3000) NOT NULL,
  `info_type` varchar(100) NOT NULL DEFAULT '',
  `update_job_title` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `job_id` (`job_id`),
  KEY `tbl_job_info_location_id` (`location_id`),
  CONSTRAINT `tbl_jobs_info_ibfk_1` FOREIGN KEY (`job_id`) REFERENCES `tbl_jobs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_jobs_info: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_jobs_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_jobs_info` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_job_category
CREATE TABLE IF NOT EXISTS `tbl_job_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `job_id` int(11) NOT NULL,
  `category` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `job_id` (`job_id`),
  CONSTRAINT `job_id.ibfk` FOREIGN KEY (`job_id`) REFERENCES `tbl_jobs` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_job_category: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_job_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_job_category` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_job_invitation
CREATE TABLE IF NOT EXISTS `tbl_job_invitation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `applicant_id` int(11) NOT NULL,
  `job_id` int(11) NOT NULL,
  `sender_id` int(11) NOT NULL,
  `message` text NOT NULL,
  `status` int(11) NOT NULL COMMENT '0 - pending ; 1 - accepted ; 2 - declined',
  `date_sent` datetime NOT NULL,
  `date_respond` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `applicant_id` (`applicant_id`,`job_id`,`sender_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_job_invitation: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_job_invitation` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_job_invitation` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_location
CREATE TABLE IF NOT EXISTS `tbl_location` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `city` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `country` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_location: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_location` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_location` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_lp_registrant_email
CREATE TABLE IF NOT EXISTS `tbl_lp_registrant_email` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` text COLLATE utf8_unicode_ci NOT NULL,
  `type` enum('employer','applicant') COLLATE utf8_unicode_ci NOT NULL,
  `date_registered` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1206 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table job_acc_v2.tbl_lp_registrant_email: 0 rows
/*!40000 ALTER TABLE `tbl_lp_registrant_email` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_lp_registrant_email` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_subscriber
CREATE TABLE IF NOT EXISTS `tbl_subscriber` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL,
  `subs_fname` varchar(100) NOT NULL,
  `subs_lname` varchar(100) NOT NULL,
  `subs_city_add` varchar(100) NOT NULL,
  `subs_state_add` varchar(100) NOT NULL,
  `subs_country_add` varchar(100) NOT NULL,
  `status` int(11) NOT NULL COMMENT '0 : default , 1 : canceled subscription , 2 : no response',
  `date_registered` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_subscriber: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_subscriber` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subscriber` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_web_content
CREATE TABLE IF NOT EXISTS `tbl_web_content` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `url` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_web_content: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_web_content` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_web_content` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_web_emails
CREATE TABLE IF NOT EXISTS `tbl_web_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` text COLLATE utf8_unicode_ci NOT NULL,
  `sending_date` date NOT NULL,
  `sending_hour` int(11) NOT NULL DEFAULT '0' COMMENT '0 - 23 (24 hour format)',
  `sending_count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table job_acc_v2.tbl_web_emails: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_web_emails` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_web_emails` ENABLE KEYS */;

-- Dumping structure for table job_acc_v2.tbl_work_experience
CREATE TABLE IF NOT EXISTS `tbl_work_experience` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `applicant_id` int(11) NOT NULL,
  `job_title` varchar(100) NOT NULL,
  `company_name` varchar(100) NOT NULL,
  `company_address` varchar(100) NOT NULL,
  `salary` varchar(100) NOT NULL,
  `year_start` int(11) NOT NULL,
  `month_start` int(11) NOT NULL,
  `year_end` int(11) NOT NULL,
  `month_end` int(11) NOT NULL,
  `currently_working` varchar(100) NOT NULL,
  `responsibilities` varchar(1000) NOT NULL,
  `accomplishments` varchar(1000) NOT NULL,
  `skills_used` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table job_acc_v2.tbl_work_experience: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_work_experience` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_work_experience` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
