<?php
/**
 * Class that operate on table 'tbl_update_description'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-01 09:20
 */
class TblUpdateDescriptionMySqlDAO implements TblUpdateDescriptionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblUpdateDescriptionMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_update_description WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_update_description';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_update_description ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblUpdateDescription primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_update_description WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUpdateDescriptionMySql tblUpdateDescription
 	 */
	public function insert($tblUpdateDescription){
		$sql = 'INSERT INTO tbl_update_description (tbl_version_id, description) VALUES (?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblUpdateDescription->tblVersionId);
		$sqlQuery->set($tblUpdateDescription->description);

		$id = $this->executeInsert($sqlQuery);	
		$tblUpdateDescription->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUpdateDescriptionMySql tblUpdateDescription
 	 */
	public function update($tblUpdateDescription){
		$sql = 'UPDATE tbl_update_description SET tbl_version_id = ?, description = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblUpdateDescription->tblVersionId);
		$sqlQuery->set($tblUpdateDescription->description);

		$sqlQuery->setNumber($tblUpdateDescription->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_update_description';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByTblVersionId($value){
		$sql = 'SELECT * FROM tbl_update_description WHERE tbl_version_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDescription($value){
		$sql = 'SELECT * FROM tbl_update_description WHERE description = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByTblVersionId($value){
		$sql = 'DELETE FROM tbl_update_description WHERE tbl_version_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDescription($value){
		$sql = 'DELETE FROM tbl_update_description WHERE description = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblUpdateDescriptionMySql 
	 */
	protected function readRow($row){
		$tblUpdateDescription = new TblUpdateDescription();
		
		$tblUpdateDescription->id = $row['id'];
		$tblUpdateDescription->tblVersionId = $row['tbl_version_id'];
		$tblUpdateDescription->description = $row['description'];

		return $tblUpdateDescription;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblUpdateDescriptionMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>