<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-03-21 01:40
 */
interface TblDatabaseListDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblDatabaseList 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblDatabaseList primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDatabaseList tblDatabaseList
 	 */
	public function insert($tblDatabaseList);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDatabaseList tblDatabaseList
 	 */
	public function update($tblDatabaseList);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUb($value);

	public function queryByDatabaseName($value);

	public function queryByStatus($value);

	public function queryByDateCreated($value);

	public function queryByDateUsed($value);

	public function queryByVersion($value);


	public function deleteByUb($value);

	public function deleteByDatabaseName($value);

	public function deleteByStatus($value);

	public function deleteByDateCreated($value);

	public function deleteByDateUsed($value);

	public function deleteByVersion($value);


}
?>