<?php
	$x = new Cron;
	print_r($x->loadNewDatabase());
	
	Class Cron
	{
		function __construct(){
			require_once 'libs/Server.php';
			require_once 'include_dao.php';
			require_once 'libs/cpanel_api.php';
		}
	
		function getQueuedDatabase()
		{
			$db = DAOFactory::getTblDatabaseListDAO()->getQueuedActivate();
			return $db;
		}
	
		function loadNewDatabase(){
			
			$cpanel = new CPanel_Api;
			
			
			
			$queued = $this->getQueuedDatabase();
			if(!empty($queued))
			{
				$dbName = $queued[0]['database_name'];
				
				$data = $this->url_get_contents(MAIN_URL.'databases/'.$queued[0]['ub'].'.sql');
				if(!empty($data))
				{
					$conn = new mysqli(DATABASEHOST, GENERATEDDATABASEUSER, GENERATEDDATABASEPASS);
					if(SERVERTYPE != 'local'){
						
						/* ****** for live ****** */
						$database = str_replace(GENERATEDDATABASEUSER_PRE,"",$dbName);
						$cpanel->create_database($database);
						
						
					} else {
						
						/* ***** for local **** */
						$conn->query('Create database `'.$dbName.'`;');
						
					}
					
					$conn->select_db($dbName);
					
					if ($conn->multi_query($data) === TRUE) {
						$conn->close();
					} else {
						echo "Error Setting up Data Tables: " . $conn->error;
						$conn->close();
						exit;
					}
					
					$version = date('mdy-Hi');
					
					$data = DAOFactory::getTblDatabaseListDAO()->queryByDatabaseName($dbName)[0];
					
					$data->status = 'available';
					$data->version = $version;
					
					$this->createNewQueue($data);
					DAOFactory::getTblDatabaseListDAO()->update($data);
					$this->setLogs('admin transaction', 'Activate DB from Cronjabs:'.$dbName);
				}
			}
			
		}
		
		function createNewQueue($data)
		{
			$getList = DAOFactory::getTblDatabaseListDAO()->getDbListSortByDbName($data->ub);
			if(!empty($getList))
			{
				$getList = $getList[0];
				$alpha = preg_replace("/[^a-zA-Z_]+/", "", $getList['database_name']);
				$numeric = preg_replace("/[^0-9]+/", "", $getList['database_name']);
				
				
				$i = 1;
				while(true)
				{
					$newN = str_pad(($numeric+$i), strlen($numeric), '0', STR_PAD_LEFT); 
					$newDbName = $alpha.$newN;
				
					$gL = DAOFactory::getTblDatabaseListDAO()->queryByDatabaseName($newDbName);
					if(empty($gL))
					{
						break;
					}
					else
					{
						$i++;
					}
				}
				
				$dList = new TblDatabaseList();
				$dList->ub = $data->ub;
				$dList->databaseName = $newDbName;
				$dList->status = 'queue';
				$dList->dateCreated = date('Y-m-d H:i:s');
				$dList->dateUsed = '0000-00-00 00:00:00';
				$dList->version = '';
				DAOFactory::getTblDatabaseListDAO()->insert($dList);
			}
			
		}
		
		static function setLogs($type = 'api', $msg){
			
			$logs = new TblLog();
			
			$logs->log = $msg;
			$logs->type = 'admin Transaction';
			$logs->dateTime = date('Y-m-d H:i:s');
			DAOFactory::getTblLogsDAO()->insert($logs);
		}
		
		function url_get_contents($url) 
		{
			if (!function_exists('curl_init')){ 
				die('Error 500!');
			}
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			$output = curl_exec($ch);
			curl_close($ch);
			return $output;
		}
	}