<?php
class Controller{
	function __construct(){
		$this->view = new Views();
	}
	
	public function loadModel($name){
		$path = 'model/' . $name . '_model.php';
		if(file_exists($path)){
			require $path;
			$modelName = $name . '_model';
			$this->model = new $modelName();
		}
	}
	
	static function removeComma($string){
		$pattern = '/^\(/';
		
		$matches = array();
		
		preg_match($pattern,$string,$matches);
		
		if(substr($string,0,1) == '('){
			$string = strtr($string, array('(' => '', ')' => ''));
			
			$string = '-'.$string;
		}
		
		$string = str_replace(',', '', $string);
		
		return $string;
		
	}
	
	static function setComma($string){
		 $a = str_replace(',', '', $string);
		 
		 return $a;
	}
	
	
	static function getFloat($int){
		
		if($int == ''){
			return '0.00&nbsp;';
		}
		$int = floatval($int);
		if($int < 0){
			$int *= (-1);
			return '('.number_format($int,2, '.', ',').')';
		} else {
			return number_format($int,2, '.', ',').'&nbsp;';
		}
	}
	
	static function objToArray($obj){
		$array = array();
		foreach($obj as $var=>$val){
			$array[$var] = $val;
		}
		return $array;
	}
	
	static function setChecked($var1, $var2){
		if($var1 == $var2){
			return 'checked';
		}
	}
	
	static function error(){
		$views = new Views();
		$views->msg = 'An error occur!</br>Page not Found!';
		$views->render('views/error/index.php');
		exit;
	}

	static function setObjFromArray($toObj, $fromArray){
		foreach($toObj as $var=>$val){
			if(isset($fromArray[$var])){
				$toObj->$var = self::removeComma($fromArray[$var]);
			}
		}
		return $toObj;
	}
	
	static function setObjFromMultiArray($toObj, $fromArray, $index){
		foreach($toObj as $var=>$val){
			if(isset($fromArray[$var])){
				if(isset($fromArray[$var][$index])){
					$toObj->$var = self::removeComma($fromArray[$var][$index]);
				}
			}
		}
		return $toObj;
	}
}